// Test_KeyChkDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Test_KeyChk.h"
#include "Test_KeyChkDlg.h"
#include "Scb.h"

SCB scb;

extern "C" __declspec(dllimport) void WINAPI KEYCHK( SCB *lpSCB );

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CTest_KeyChkDlg dialog

CTest_KeyChkDlg::CTest_KeyChkDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CTest_KeyChkDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTest_KeyChkDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CTest_KeyChkDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
    ON_BN_CLICKED(IDC_DOKEYCHK1, &CTest_KeyChkDlg::OnDoKeyChk1)
    ON_BN_CLICKED(IDC_DOKEYCHK2, &CTest_KeyChkDlg::OnDoKeyChk2)
END_MESSAGE_MAP()


// CTest_KeyChkDlg message handlers

BOOL CTest_KeyChkDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

    // Set default values from the Examples.evk Options File.
	SetDlgItemText(IDC_PROD_ID_TO_USE, L"Examples");
	SetDlgItemText(IDC_PIN_TO_USE, L"375391873");
	SetDlgItemText(IDC_ECL_UPDATE, L"-1");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTest_KeyChkDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTest_KeyChkDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTest_KeyChkDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CTest_KeyChkDlg::OnDoKeyChk1()
{
    CTest_KeyChkDlg::OnDoKeyChk(1);
}

void CTest_KeyChkDlg::OnDoKeyChk2()
{
    CTest_KeyChkDlg::OnDoKeyChk(2);
}

void CTest_KeyChkDlg::OnDoKeyChk(UINT nFunction)
{
	HCURSOR	hSaveCursor;
	WCHAR	szText[255], szConverted[255];
    size_t  size, length;

	// Zero the SCB structure.
	memset( &scb, 0, sizeof( SCB ) );

	// Initialize the SCB fields necessary to call the KEYCHK function.
	scb.err_code = 0x6240;				    // Preset Error to "SCB Not Found".
	strncpy_s(scb.scb_id, 5, "Kc.6", 4);	// Initialize SCB Signature ID.
	scb.func_code = nFunction;			    // Use Function from I/P parm.

    // Get "Product-ID To Use" from screen field & convert to ASCII for SCB.
    GetDlgItemText(IDC_PROD_ID_TO_USE, szText, sizeof(szText));
    size = sizeof(scb.prod_id);
    wcstombs_s(&length, scb.prod_id, size, szText, size);

    // Get "PIN To Use" from screen field & convert to DWORD for SCB.
    GetDlgItemText(IDC_PIN_TO_USE, szText, sizeof(szText));
    scb.pin = wcstoul(szText, NULL, 10);

    // Get "ECL Update" from screen field & convert to INT16 for SCB.
    GetDlgItemText(IDC_ECL_UPDATE, szText, sizeof(szText));
    scb.ecl = LOWORD(wcstol(szText, NULL, 10));

	// Save the current cursor and then set it to the hourglass (waiting) cursor.
	hSaveCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	// Perform the Authorization Check using the KeyChk DLL.
    KEYCHK( &scb );

	// Restore the original cursor.
	SetCursor(hSaveCursor);

	// Display the result of the Authorization Check.
	if(scb.err_code)
		SetDlgItemText(IDC_CHK_STATUS, L" Failed");
	else
		SetDlgItemText(IDC_CHK_STATUS, L" Passed");

	// Display the full Error Code.
	wsprintf(szText, L" %04X-%04X-%04X", scb.err_code, scb.err_status1, scb.err_status2);
    SetDlgItemText(IDC_ERR_CODE, szText);

	// Display the Function Code.
	wsprintf(szText, L" %d", scb.func_code);
	SetDlgItemText(IDC_FUNC_CODE, szText);

	// Display the Product-ID (ASCII).
    size = strlen(scb.prod_id);
    mbstowcs_s( &length, szConverted, scb.prod_id, size+1 );
	wsprintf(szText, L" %s", szConverted);
	SetDlgItemText(IDC_PROD_ID, szText);

	// Display the Product Serial Number.
	wsprintf(szText, L" %lu", scb.prod_serial);
	SetDlgItemText(IDC_SERIAL, szText);

	// Display the Exec-Count Limit.
    if(scb.ecl == -1)
		wsprintf(szText, L" Unlimited");
    else
        wsprintf(szText, L" %u", scb.ecl);
	SetDlgItemText(IDC_ECL, szText);

    // Display the Expire-Days Limit.
    if(scb.edl == 0xFFFF)
		wsprintf(szText, L" Unlimited");
    else
        wsprintf(szText, L" %d", scb.edl);
	SetDlgItemText(IDC_EDL, szText);

	// Display the ASCII Expire-Date.
    size = strlen(scb.ed_ascii);
    mbstowcs_s( &length, szConverted, scb.ed_ascii, size+1 );
	wsprintf(szText, L" %s", szConverted);
	SetDlgItemText(IDC_ED_ASCII, szText);

	// Display the Unicode Expire-Date.
	wsprintf(szText, L" %s", scb.expire_date);
	SetDlgItemText(IDC_EXPIRE_DATE, szText);

	// Display the Unicode Expire-Time.
	wsprintf(szText, L" %s", scb.expire_time);
	SetDlgItemText(IDC_EXPIRE_TIME, szText);

    // Display the User-Data.
    wsprintf(szText,
		     L" %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X",
             scb.user_data[0], scb.user_data[1], scb.user_data[2], scb.user_data[3],
             scb.user_data[4], scb.user_data[5], scb.user_data[6], scb.user_data[7],
             scb.user_data[8], scb.user_data[9], scb.user_data[10], scb.user_data[11],
             scb.user_data[12], scb.user_data[13], scb.user_data[14], scb.user_data[15]);
	SetDlgItemText(IDC_USER_DATA, szText);

    // Display the Feature-Flags.
    wsprintf(szText, L" %04X", scb.feature_flags);
	SetDlgItemText(IDC_FEATURE_FLAGS, szText);

    // Display the Device Lasered-ID.
    wsprintf(szText,
		     L" %02X %02X %02X %02X %02X %02X %02X %02X",
             scb.lasered_id[0], scb.lasered_id[1], scb.lasered_id[2], scb.lasered_id[3],
             scb.lasered_id[4], scb.lasered_id[5], scb.lasered_id[6], scb.lasered_id[7]);
	SetDlgItemText(IDC_LASERED_ID, szText);

    // Display the Type of Device determined by the Lasered-ID.
	if(scb.lasered_id[0] == 0xE1)
		SetDlgItemText(IDC_DEV_TYPE, L" Rockey4");
	else if(scb.lasered_id[0] == 0xE2)
		SetDlgItemText(IDC_DEV_TYPE, L" Rockey4ND");
	else
		SetDlgItemText(IDC_DEV_TYPE, L" Unknown");

    // Display the Reg-Info Name.
    wsprintf(szText, L" %s", scb.reg_name);
	SetDlgItemText(IDC_REG_NAME, szText);

    // Display the Reg-Info Company.
    wsprintf(szText, L" %s", scb.reg_company);
	SetDlgItemText(IDC_REG_COMPANY, szText);

    // Display the Reg-Info Other.
    wsprintf(szText, L" %s", scb.reg_other);
	SetDlgItemText(IDC_REG_OTHER, szText);
}

// End of Source File.
