Option Strict On
Option Explicit On
Module KeySCB
    ' 512-Byte Structure for Communication to/from KeyChk DLL.

    Structure SCB
        Dim Err_Code As UInt16      ' Error Code.
        Dim Err_Status1 As UInt16   ' Error Status 1.
        Dim Err_Status2 As UInt16   ' Error Status 2.
        Dim Func_Code As Byte       ' KeyChk Function Code.
        <VBFixedString(5), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=5)> Public SCB_ID As String ' SCB ID s/b "Kc.6".
        <VBFixedString(9), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=9)> Public Prod_ID As String ' Product-ID (UTF-8).
        Dim Reserved1 As Byte       ' Reserved.
        Dim Feature_Flags As UInt16 ' Feature-Flags 1-16:
        '   Least Significant Bit = Flag 1.
        '   Most Significant Bit = Flag 16.
        Dim Prod_Serial As UInt32   ' Product Serial Number.
        Dim PIN As UInt32           ' Product PIN.
        Dim ECL As Int16            ' Uses Limit (ECL).
        '        -1: Key is Unlimited.
        '         0: Key is Expired.
        '  1-32,767: Number of Uses Left.
        Dim EDL As UInt16           ' Time Limit (EDL).
        '    &HFFFF: Key is Unlimited.
        '         0: Key is Expired.
        '  1-65,534: Number Days Left.
        <VBFixedString(9), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=9)> Public ED_ASCII As String ' Expire-Date (ASCIIZ).
        Dim User_Data_01 As Byte    ' User-Data.
        Dim User_Data_02 As Byte
        Dim User_Data_03 As Byte
        Dim User_Data_04 As Byte
        Dim User_Data_05 As Byte
        Dim User_Data_06 As Byte
        Dim User_Data_07 As Byte
        Dim User_Data_08 As Byte
        Dim User_Data_09 As Byte
        Dim User_Data_10 As Byte
        Dim User_Data_11 As Byte
        Dim User_Data_12 As Byte
        Dim User_Data_13 As Byte
        Dim User_Data_14 As Byte
        Dim User_Data_15 As Byte
        Dim User_Data_16 As Byte
        <VBFixedString(6), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=6)> Public Reserved2 As String ' Reserved.
        Dim Lasered_ID_1 As Byte    ' Device Lasered-ID (LID).
        Dim Lasered_ID_2 As Byte
        Dim Lasered_ID_3 As Byte
        Dim Lasered_ID_4 As Byte
        Dim Lasered_ID_5 As Byte
        Dim Lasered_ID_6 As Byte
        Dim Lasered_ID_7 As Byte
        Dim Lasered_ID_8 As Byte
        <VBFixedString(437), System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=437)> Public Reserved3 As String ' Reserved.
    End Structure

    ' Declare KeyChk DLL function.
    Declare Sub KEYCHK Lib "KeyChk.DLL" (ByRef lpUserSCB As SCB)

    Sub CheckSCB(ByRef UserSCB As SCB, ByRef keychkFunction As Byte)

        ' Change to a "Wait" cursor to let the User know we are working.
        System.Windows.Forms.Cursor.Current = System.Windows.Forms.Cursors.WaitCursor

        ' Setup the SCB for calling the KeyChk DLL.
        UserSCB.Err_Code = &H6240 ' Preset Error to "SCB Not Found".
        UserSCB.SCB_ID = "Kc.6" ' Initialize SCB Signature ID.
        UserSCB.Func_Code = keychkFunction ' Use Function from I/P parm.
        UserSCB.Prod_ID = "Examples" & Chr(0) ' Use Product Name from EVK file.
        UserSCB.PIN = 375391873 ' Use PIN from Examples.EVK file.
        UserSCB.Prod_Serial = 0 ' Have KeyChk return Serial Number of Key.
        UserSCB.ECL = -1 ' Amount to "add" to Uses Limit if Function is '2' or '3'.

        ' Call the KeyChk DLL to perform the Authorization Check.
        KEYCHK(UserSCB)

        ' Restore the default cursor.
        System.Windows.Forms.Cursor.Current = System.Windows.Forms.Cursors.Default

    End Sub
End Module