﻿Imports System.Runtime.InteropServices

Public Class Form1

    'Create an SCB memory block for sending data to/from the KeyChk DLL.
    Dim KeyChkSCB As SCB

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load

        ' Set the screen fields of "Product-ID" and "Product PIN" to show the
        '   values that were used by KeyBuild to build the Examples Key.
        ' These values will be copied to the SCB before calling the KeyChk DLL.
        TextBox1.Text = "Examples"
        TextBox2.Text = "375391873"
    End Sub

    Private Sub btn_Exit_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        ' End the program now.
        Me.Close()
    End Sub

    Private Sub btn1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        ' Button1 was just Clicked.
        '
        ' Call the Do_KeyChk_Call() Sub specifying '1'.
        '
        ' That will:
        '   - Copy the screen fields to the SCB.
        '   - Call KeyChk with Function 1
        '       to verify the presence of the Key with this Product-ID and PIN.
        '
        ' Go copy screen values to SCB and call KeyChk.
        Do_KeyChk_Call(1)

    End Sub

    Private Sub btn2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        ' Button2 was just Clicked.
        '
        ' Call the Do_KeyChk_Call() Sub specifying '2'.
        '
        ' That will:
        '   - Copy the screen fields to the SCB.
        '   - Call KeyChk with Function 1
        '       to verify the presence of the Key with this Product-ID and PIN
        '       AND Update the Uses Limit of the Key.
        '
        ' Go copy screen values to SCB and call KeyChk.
        Do_KeyChk_Call(2)

    End Sub

    Sub Do_KeyChk_Call(ByVal keychk_func As Byte)
        ' This Sub setups the SCB and calls the KeyChk DLL.
        '
        ' The Caller has set the keychk_func parameter to the
        '   KeyChk Function to use.

        ' Before calling KeyChk, set the SCB Error Code to "SCB Not Found".
        '   If, for some reason, KeyChk can't find the SCB memory block,
        '   it will not be able to access and set the "err_code" SCB field.
        '   Pre-Setting this error code allows us to know if this happened.
        KeyChkSCB.Err_Code = &H6240

        ' Before calling KeyChk, set the "Func_Code" SCB field
        '   to what the Caller passed to us in the "keychk_func" parameter.
        KeyChkSCB.Func_Code = keychk_func

        ' Before calling KeyChk, initialize the "SCB_ID" SCB field so
        '   KeyChk will know that it's using the correct memory block.
        KeyChkSCB.SCB_ID = "Kc.6"

        ' Before calling KeyChk, set the "Prod-ID" SCB field to "Examples"
        '   since this is the Product-ID of the Examples Key.
        '   The "Product-ID" screen field has already been set to "Examples".
        ' This field must match the Product-ID of the Key that you want to find.
        '   In your Source Code, you would set this field to the Product-ID
        '     of your Product. This is shown on the KeyBuild "Build Keys" panel.
        ' The Product-ID is a zero-terminated, case-sensitive, UTF8 Unicode field.
        KeyChkSCB.Prod_ID = TextBox1.Text

        ' Before calling KeyChk, set the "Prod_Serial" field to Zero
        '   to skip the validation of the Key's Serial Number.
        ' Normally, you will set the "prod_serial" SCB field to zero so
        '   the Key check will succeed as long as KeyChk finds a Key
        '   with your specific Product-ID and Product PIN.
        '   In this case, the Serial Number of the Key found
        '     will be returned in the "prod_serial" SCB field.
        ' If you want to verify that the Key present has a
        '   specific Product Serial Number, then set this field to
        '   the specific Serial Number that you want to verify.
        KeyChkSCB.Prod_Serial = 0

        ' Before calling KeyChk, set the "Prod_PIN" SCB field to "375391873"
        '   since this is the Product PIN of the Examples Key.
        '   The "Product PIN" screen field has already been set to "375391873".
        ' This field must match the Product PIN of the Key that you want to find.
        '   In your Source Code, you would set this field to the Product PIN
        '     of your Product. This is shown on the KeyBuild "Build Keys" panel.
        KeyChkSCB.Prod_PIN = Convert.ToUInt32(TextBox2.Text)

        ' Before calling KeyChk, copy the "Uses Limit Update" screen field
        '   to the "Uses_Limit" SCB field.
        ' NOTE: The Uses Limit of the Key is only updated
        '       if KeyChk Function 2 or 3 is used.
        ' To update the Uses Limit of the Key from this Example program,
        '   set the "Uses Limit Update" screen field to '-1', '-2' or '-3'
        '   and then click the "Do KeyChk Function 2" button.
        KeyChkSCB.Uses_Limit = CShort(NumericUpDown1.Value)

        ' Before calling KeyChk,
        '   clear out all the screen field results from the last run.
        TextBox3.Text = ""
        TextBox4.Text = ""
        TextBox5.Text = ""
        TextBox6.Text = ""
        TextBox7.Text = ""
        TextBox8.Text = ""
        TextBox9.Text = ""
        TextBox10.Text = ""
        TextBox11.Text = ""
        TextBox12.Text = ""
        TextBox13.Text = ""
        TextBox14.Text = ""
        TextBox15.Text = ""
        TextBox16.Text = ""

        ' Change to a "Wait" cursor to let the User know we are doing something.
        System.Windows.Forms.Cursor.Current = System.Windows.Forms.Cursors.WaitCursor

        ' Call the KeyChk DLL using the values setup in the SCB.
        '   This will check for the presence of the Key that matches
        '     the Product-ID and Product PIN fields.
        ' If the Key is found, all the information from the Key will
        '   be returned in the SCB.
        KeyChk(KeyChkSCB)

        ' Restore the default cursor.
        System.Windows.Forms.Cursor.Current = System.Windows.Forms.Cursors.Default

        ' Display the Result of the Key Check operation.
        If KeyChkSCB.Err_Code = 0 Then
            TextBox3.Text = "The Key was Found and is Not Expired."
        ElseIf KeyChkSCB.Err_Code = &H6043 Then
            TextBox3.Text = "The Key was Not Found."
        ElseIf KeyChkSCB.Err_Code = &H6142 Then
            TextBox3.Text = "The Key was Found but the Uses Limit is Expired."
        ElseIf KeyChkSCB.Err_Code = &H6143 Then
            TextBox3.Text = "The Key was Found but the Time Limit is Expired."
        Else
            TextBox3.Text = "The Key Check Failed and the Error Code will Explain why."
        End If

        ' Display the Full Error Code in Hexadecimal.
        TextBox4.Text = Convert.ToString(KeyChkSCB.Err_Code, 16).PadLeft(4, "0"c).ToUpper
        TextBox4.Text = TextBox4.Text & "-" & Convert.ToString(KeyChkSCB.Err_Status1, 16).PadLeft(4, "0"c).ToUpper
        TextBox4.Text = TextBox4.Text & "-" & Convert.ToString(KeyChkSCB.Err_Status2, 16).PadLeft(4, "0"c).ToUpper

        ' If there was any Error besides "Expired", we don't need
        '   to show the Key's Information since it's probably Invalid.
        '
        ' So, only show the Key's Information if the Error Code is:
        '        0 - The Key was Found and is Not Expired.
        '   0x6142 - The Key was Found but the Uses Limit is Expired.
        '   0x6143 - The Key was Found but the Time Limit is Expired.
        If KeyChkSCB.Err_Code <> 0 And _
            KeyChkSCB.Err_Code <> &H6142 And _
            KeyChkSCB.Err_Code <> &H6143 Then
            Return
        End If

        ' Display the Product Serial Number.
        TextBox5.Text = Str(KeyChkSCB.Prod_Serial)

        ' Display the current Uses Limit.
        If KeyChkSCB.Err_Code = &H6142 Then
            TextBox6.Text = "Expired"
        ElseIf KeyChkSCB.Uses_Limit = -1 Then
            TextBox6.Text = "Unlimited"
        ElseIf KeyChkSCB.Uses_Limit = 0 Then
            TextBox6.Text = "On Last Use"
        Else
            TextBox6.Text = Str(KeyChkSCB.Uses_Limit)
        End If

        ' Display the current Time Limit.
        If KeyChkSCB.Err_Code = &H6143 Then
            TextBox7.Text = "Expired"
        ElseIf KeyChkSCB.Time_Limit = &HFFFF Then
            TextBox7.Text = "Unlimited"
        ElseIf KeyChkSCB.Time_Limit = 0 Then
            TextBox7.Text = "On Last Day"
        Else
            TextBox7.Text = Str(KeyChkSCB.Time_Limit) + " Day(s)"
        End If

        ' Display the Expire-Date (Local Time Zone, Unicode).
        TextBox8.Text = KeyChkSCB.scb_utf16.Expire_Date

        ' Display the Expire-Time (Local Time Zone, Unicode).
        TextBox9.Text = KeyChkSCB.scb_utf16.Expire_Time

        ' Display the User-Data.
        TextBox10.Text = Convert.ToString(KeyChkSCB.User_Data_01, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_02, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_03, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_04, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_05, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_06, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_07, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_08, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_09, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_10, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_11, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_12, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_13, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_14, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_15, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox10.Text = TextBox10.Text & Convert.ToString(KeyChkSCB.User_Data_16, 16).PadLeft(2, "0"c).ToUpper

        ' Display the Feature-Flags.
        Dim ff_test_bit As UInt32 = &H1 ' Setup to test 1st FF bit.
        Dim ff_str As String = ""       ' Start with an empty string.
        If KeyChkSCB.Feature_Flags = 0 Then
            ff_str = "None "
        Else
            For ff As Integer = 1 To 16
                If (KeyChkSCB.Feature_Flags And ff_test_bit) = ff_test_bit Then
                    ff_str = ff_str & Convert.ToString(ff) & " "
                End If
                ff_test_bit = CUInt(ff_test_bit * 2)
            Next
        End If
        ' Also show the Feature-Flags Word Field (Hex).
        ff_str = ff_str & "(&H" & _
            Convert.ToString(KeyChkSCB.Feature_Flags, 16).PadLeft(4, "0"c).ToUpper & ")"
        TextBox11.Text = ff_str

        ' Display the Lasered-ID.
        TextBox12.Text = Convert.ToString(KeyChkSCB.Lasered_ID_1, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox12.Text = TextBox12.Text & Convert.ToString(KeyChkSCB.Lasered_ID_2, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox12.Text = TextBox12.Text & Convert.ToString(KeyChkSCB.Lasered_ID_3, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox12.Text = TextBox12.Text & Convert.ToString(KeyChkSCB.Lasered_ID_4, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox12.Text = TextBox12.Text & Convert.ToString(KeyChkSCB.Lasered_ID_5, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox12.Text = TextBox12.Text & Convert.ToString(KeyChkSCB.Lasered_ID_6, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox12.Text = TextBox12.Text & Convert.ToString(KeyChkSCB.Lasered_ID_7, 16).PadLeft(2, "0"c).ToUpper & " "
        TextBox12.Text = TextBox12.Text & Convert.ToString(KeyChkSCB.Lasered_ID_8, 16).PadLeft(2, "0"c).ToUpper

        ' Display the Key Type of Device determined by the Lasered-ID.
        If KeyChkSCB.Lasered_ID_1 = &HE1 Then
            TextBox13.Text = "Rockey4"
        ElseIf KeyChkSCB.Lasered_ID_1 = &HE2 Then
            TextBox13.Text = "Rockey4ND"
        Else
            TextBox13.Text = "Unknown"
        End If

        ' Display the Registered Name (Unicode).
        TextBox14.Text = KeyChkSCB.scb_utf16.Reg_Name

        ' Display the Registered Company (Unicode).
        TextBox15.Text = KeyChkSCB.scb_utf16.Reg_Company

        ' Display the Registered Other Info (Unicode).
        TextBox16.Text = KeyChkSCB.scb_utf16.Reg_Other

    End Sub

    Private Function UnicodeBytesToString(ByVal bytes() As Byte) As String
        Return System.Text.Encoding.UTF8.GetString(bytes)
    End Function
    Private Function UnicodeStringToBytes(ByVal str As String) As Byte()
        Return System.Text.Encoding.UTF8.GetBytes(str)
    End Function

End Class
